Rem LabelGraphics.vbs
Rem An InDesign CS3 VBScript
Rem
Rem Adds labels to the graphics in the active document.
main
function main()
	Set myInDesign = CreateObject("InDesign.Application.CS3")
	If myInDesign.Documents.Count > 0 Then
		If myInDesign.Documents.item(1).AllGraphics.Count > 0 Then
			myDisplayDialog myInDesign
		Else
			msgbox "Document contains no graphics."
		End If
	Else
		MsgBox "Please open a document and try again."
	End If
End Function
Function myDisplayDialog(myInDesign)
	myLabelWidth = 100
	Set myDocument = myInDesign.Documents.Item(1)
	myStyleNames = myGetStyleNames(myDocument)
	myLayerNames = myGetLayerNames(myDocument)
	myLabelTypes = Array("File Name", "File Path", "XMP Description", "XMP Author")
	Set myDialog = myInDesign.Dialogs.Add
	With myDialog
		.name = "LabelGraphics"
		With .DialogColumns.Add
			Rem Label type
			With .DialogRows.Add
				With .DialogColumns.Add
					With .StaticTexts.Add
						.staticLabel = "Label Type:"
						.minWidth = myLabelWidth
					End With
				End With
				With .DialogColumns.Add
					Set myLabelTypeDropdown = .Dropdowns.Add
					myLabelTypeDropdown.stringList = myLabelTypes
					myLabelTypeDropdown.selectedIndex = 0
				End With
			End With
			Rem Label text frame height and associated static text.
			With .DialogRows.Add
				With .DialogColumns.Add
					With .StaticTexts.Add
						.StaticLabel = "Label Height:"
						.MinWidth = myLabelWidth
					End With
				End With
				With .DialogColumns.Add
					Set myLabelHeightField = .MeasurementEditboxes.Add
					myLabelHeightField.EditValue = 24
					myLabelHeightField.EditUnits = idMeasurementUnits.idPoints
				End With
			End With
			Rem Label text frame offset and associated static text.
			With .DialogRows.Add
				With .DialogColumns.Add
					With .StaticTexts.Add
						.StaticLabel = "Label Offset:"
						.MinWidth = myLabelWidth
					End With
				End With
				With .DialogColumns.Add
					Set myLabelOffsetField = .MeasurementEditboxes.Add
					myLabelOffsetField.EditValue = 0
					myLabelOffsetField.EditUnits = idMeasurementUnits.idPoints
				End With
			End With
			Rem Label paragraph style and associated static text.
			With .DialogRows.Add
				With .DialogColumns.Add
					With .StaticTexts.Add
						.StaticLabel = "Label Style:"
						.MinWidth = myLabelWidth
					End With
				End With
				With .DialogColumns.Add
					Set myLabelStyleDropdown = .Dropdowns.Add
					myLabelStyleDropdown.StringList = myStyleNames
					myLabelStyleDropdown.SelectedIndex = 0
				End With
			End With
			Rem Label layer and associated static text.
			With .DialogRows.Add
				With .DialogColumns.Add
					With .StaticTexts.Add
						.StaticLabel = "Label Layer:"
						.MinWidth = myLabelWidth
					End With
				End With
				With .DialogColumns.Add
					Set myLabelLayerDropdown = .Dropdowns.Add
					myLabelLayerDropdown.StringList = myLayerNames
					myLabelLayerDropdown.SelectedIndex = 0
				End With
			End With
		End With
	End With
    myResult = myDialog.Show
    If myResult = True Then
        myLabelHeight = myLabelHeightField.EditValue
        myLabelOffset = myLabelOffsetField.EditValue
        myLabelType = myLabelTypes(myLabelTypeDropdown.SelectedIndex)
        myLabelStyleName = myStyleNames(myLabelStyleDropdown.SelectedIndex)
        myLabelLayerName = myLayerNames(myLabelLayerDropdown.SelectedIndex)
        myDialog.destroy
        myAddLabels myDocument, myLabelHeight, myLabelOffset, myLabelType, myLabelStyleName, myLabelLayerName
        MsgBox "Done!"
    Else
        myDialog.destroy
    End If
End Function
function myAddLabels(myDocument, myLabelHeight, myLabelOffset, myLabelType, myLabelStyleName, myLabelLayerName)
	myOldXUnits = myDocument.ViewPreferences.HorizontalMeasurementUnits
	myOldYUnits = myDocument.ViewPreferences.VerticalMeasurementUnits
	myOldRulerOrigin = myDocument.ViewPreferences.RulerOrigin
	myDocument.ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
	myDocument.ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
	myDocument.ViewPreferences.RulerOrigin = idRulerOrigin.idPageOrigin
	Set myGraphics = myDocument.AllGraphics
	Rem Create the label style if it does not already exist.
	On Error Resume Next
	Set myLabelStyle = myDocument.ParagraphStyles.Item(myLabelStyleName)
	If Err.Number <> 0 Then
		Set myLabelStyle = myDocument.ParagraphStyles.Add
		myLabelStyle.Name = myLabelStyleName
		Err.Clear
	End If
	On Error Goto 0
	Rem Create the label layer if it does not already exist.
	On Error Resume Next
	Set myLabelLayer = myDocument.Layers.Item(myLabelLayerName)
	If Err.Number <> 0 Then
		Set myLabelLayer = myDocument.Layers.Add
		myLabelLayer.Name = myLabelLayerName
		Err.Clear
	End If
	On Error Goto 0
	For myCounter = 1 To myGraphics.Count
		myAddLabel myDocument, myGraphics(myCounter), myLabelType, myLabelHeight, myLabelOffset, myLabelStyle, myLabelLayer
	Next
	myDocument.ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
	myDocument.ViewPreferences.VerticalMeasurementUnits = myOldYUnits
	myDocument.ViewPreferences.RulerOrigin = myOldRulerOrigin
End Function
function myAddLabel(myDocument, myGraphic, myLabelType, myLabelHeight, myLabelOffset, myLabelStyle, myLabelLayer)
    Set myFileSystemObject = CreateObject("Scripting.FileSystemObject")
	Set myLink = myGraphic.itemLink
	Rem Label type defines the text that goes in the label.
	Select Case myLabelType
		Case "File Name":
			myString = myLink.Name
		Case "File Path":
			myString = myLink.FilePath
		Case "XMP Author":
			On Error Resume Next
			myString = myLink.LinkXmp.Author
			If Err.Number <> 0 Then
				myString = "No author available."
				Err.Clear
			End If
			On Error Goto 0
		Case "XMP Description":
			On Error Resume Next
				myString = myLink.LinkXmp.Description
			If Err.Number <> 0 Then
				myString = "No description available."
				Err.Clear
			End If
			On Error Goto 0
	End Select
	Set myFrame = myGraphic.parent
	myX1 = myFrame.geometricBounds(1) 
	myY1 = myFrame.geometricBounds(2) + myLabelOffset 
	myX2 = myFrame.geometricBounds(3) 
	myY2 = myY1 + myLabelHeight
	Set myTextFrame = myFrame.Parent.TextFrames.Add
	myTextFrame.GeometricBounds = Array(myY1, myX1, myY2, myX2)
	myTextFrame.Contents = myString
	myTextFrame.TextFramePreferences.FirstBaselineOffset = idFirstBaseline.idLeadingOffset 
	myTextFrame.ParentStory.Texts.Item(1).AppliedParagraphStyle = myLabelStyle
End Function
Rem Return an array of paragraph style names.
Function myGetStyleNames(myDocument)
	myAddLabelStyle = True
	ReDim myStyleNames(0)
	For myCounter = 1 To myDocument.ParagraphStyles.Count
		If Not (IsEmpty(myStyleNames(0))) Then
	    	ReDim Preserve myStyleNames(UBound(myStyleNames) + 1)
	    End If
		myStyleNames(UBound(myStyleNames)) = myDocument.ParagraphStyles.Item(myCounter).Name
		If myDocument.ParagraphStyles.Item(myCounter).Name = "Labels" Then
			myAddLabelStyle = False
		End If
	Next
	If myAddLabelStyle = True Then
		ReDim Preserve myStyleNames(UBound(myStyleNames)+1)
		myStyleNames(UBound(myStyleNames)) = "Labels"		
	End If
	myGetStyleNames = myStyleNames
End Function
Rem Return an array of layer names.
Function myGetLayerNames(myDocument)
	myAddLabelLayer = True
	ReDim myLayerNames(0)
	For myCounter = 1 To myDocument.ParagraphStyles.Count
		If Not (IsEmpty(myLayerNames(0))) Then
	    	ReDim Preserve myLayerNames(UBound(myLayerNames) + 1)
	    End If
		myLayerNames(UBound(myLayerNames)) = myDocument.ParagraphStyles.Item(myCounter).Name
		If myDocument.ParagraphStyles.Item(myCounter).Name = "Labels" Then
			myAddLabelLayer = False
		End If
	Next
	If myAddLabelLayer = True Then
		ReDim Preserve myLayerNames(UBound(myLayerNames)+1)
		myLayerNames(UBound(myLayerNames)) = "Labels"		
	End If
	myGetLayerNames = myLayerNames
End Function